/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.ntfy.DuplicateNameException;
import com.ibm.hwmca.fw.ntfy.Startable;
import com.ibm.hwmca.fw.ntfy.eventchain.ChainedObject;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.HashMap;

public class MonitoredHashMap
extends HashMap
implements Serializable,
NotificationErrorIds {
    static final long serialVersionUID = -5866936357262447632L;
    private static final String TRACE_MASKT = "XNTYMHMT";
    private static final String TRACE_MASKF = "XNTYMHMF";
    private static final String TRACE_MASKD = "XNTYMHMD";
    public static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(65, "ntfytsklet");

    public Object put(Object key, Object value) {
        Trace.trace(TRACE_MASKT, "-> put(" + key + ")");
        if (this.containsKey(key)) {
            throw new DuplicateNameException(this, key);
        }
        if (value instanceof Startable) {
            this.startStartable((Startable)value);
        }
        Trace.trace(TRACE_MASKT, "<- put");
        return super.put(key, value);
    }

    public Object remove(Object key) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> remove(" + key + ")");
        Object result = null;
        if (this.containsKey(key)) {
            Object value = this.get(key);
            if (value instanceof ChainedObject) {
                ((ChainedObject)value).setDeleted();
            }
            if (value instanceof Startable) {
                this.stopStartable((Startable)value);
            }
            result = super.remove(key);
        }
        Trace.trace(TRACE_MASKT, "<- remove");
        return result;
    }

    public Object replace(Object key, Object newValue) {
        Object result;
        Trace.trace(TRACE_MASKT, "-> replace(" + key + ") with " + newValue);
        if (this.containsKey(key)) {
            Trace.trace(TRACE_MASKF, "replace:  found key " + key);
            Object oldValue = this.get(key);
            if (oldValue instanceof Startable) {
                this.stopStartable((Startable)oldValue);
            }
            if (newValue instanceof Startable) {
                this.startStartable((Startable)newValue);
            }
            Trace.trace(TRACE_MASKF, "replace:  oldValue is " + oldValue);
            result = super.put(key, newValue);
            Trace.trace(TRACE_MASKF, "replace:  stored new object at key");
            if (oldValue instanceof ChainedObject && newValue instanceof ChainedObject) {
                Trace.trace(TRACE_MASKF, "replace:  about to call setReplaced");
                ((ChainedObject)oldValue).setReplaced((ChainedObject)newValue);
                Trace.trace(TRACE_MASKF, "replace:  back from setReplaced");
            }
        } else {
            result = super.put(key, newValue);
        }
        Trace.trace(TRACE_MASKT, "<- replace");
        return result;
    }

    private void startStartable(Startable obj) {
        try {
            if (!obj.isStarted()) {
                obj.start();
            }
        }
        catch (Exception e) {
            new FrameworkLog(_logInfo, -32737, e).log(LogAttributes.INFO_LOG);
        }
    }

    private void stopStartable(Startable obj) {
        try {
            if (obj.isStarted()) {
                obj.stop();
            }
        }
        catch (Exception e) {
            new FrameworkLog(_logInfo, -32736, e).log(LogAttributes.INFO_LOG);
        }
    }
}

